<?php
  $rootDir = str_repeat( '../', substr_count($baseName, '/') );
  $mediaDir = $rootDir.'template_';

  // todo: use ToText instead of strip_tags.
  $title = $titleHTML = $doc->GetTitle();
  if ($title === null) {
    $title = $titleHTML = 'Unnamed page';
  } elseif (is_object($title)) {
    $titleHTML = $title->ChildrenToHTML(false);
    $title = strip_tags($titleHTML);
  }

  $pageLang = $task->currentLang;
  ExportVars(compact('title', 'rootDir', 'destBaseName', 'pageLang'), $cl);

  $pagePath = $task->PagePathOf($baseName, $doc->settings->pager);
  $favicon = "{$rootDir}favicon.ico";
?>

<??php ob_start(); ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
  <head>
    <title>
      <?php
        echo $title;

        if ($pagePath) {
          $separ = ' &laquo; ';
          foreach (array_reverse($pagePath) as $component) { echo $separ, $component['titleHTML']; }
        }
      ?>
    </title>

    <meta content="text/html; charset=utf-8" http-equiv="Content-Type" />

    <meta name="author" content="UWiki template by Proger_XP aka p4s @ mailme, smtp, ru" />
    <meta name="generator" content="&laquo;Starry Evening&raquo; template for UverseWiki" />

    <link rel="shortcut icon" href="<?php echo $favicon?>" />
    <link rel="stylesheet" href="<?php echo $mediaDir?>/styles.css" type="text/css" />

    <?php
      $extraCSS = array(dirname($baseName).'/_all.css');
        $pageCSS = substr($baseName, 0, -1 * strlen($task->inExt)).'css';
        // dir/.../page.css -> dir/.../_page.css
        $extraCSS[] = preg_replace('~([\\/])?([^\\/]+)$~', '\1_\2', $pageCSS);

      foreach ($extraCSS as $cssBaseName) {
        $css = $tempLocalPath.$cssBaseName;

        if (is_file($css)) {
          if (empty( $cl->options['embed-css'] )) {
            $task->destInterface->CopyFile($css, $cssBaseName);
            echo '<link rel="stylesheet" href="'.basename($cssBaseName)."\" type=\"text/css\" />\n";
          } else {
            echo "<style type=\"text/css\">\n", file_get_contents($css), "\n</style>\n";
          }
        }
      }
    ?>

    <script type="text/javascript" src="<?php echo $mediaDir?>/common.js"></script>
    <script type="text/javascript" src="<?php echo $mediaDir?>/mouse.js"></script>
    <script type="text/javascript" src="<?php echo $mediaDir?>/slider.js"></script>
    <script type="text/javascript" src="<?php echo $mediaDir?>/template.js"></script>
  </head>
  <body>
    <a name="top"></a>

    <div style="position: absolute; width: 100%">
      <div style="background: repeat left top url(<?php echo $mediaDir?>/edge-rep.png)">
      <div style="background: repeat-x left bottom url(<?php echo $mediaDir?>/bottom-edge.png)">
      <div style="background: repeat-x left top url(<?php echo $mediaDir?>/top-edge.png)">

        <div id="outerWrapper">
          <a href="<?php echo UverseWikiHomePage?>" target="_blank" id="uwikiCredits">
            <img src="<?php echo $mediaDir?>/uwiki-credits.png" title="Powered by UverseWiki" alt="UverseWiki" />
          </a>

          <?php
            $langs = $task->ListTranslationsFor($baseName);
              foreach ($langs as $code => $path) {
                if ($code === $pageLang) { unset( $langs[$code] ); }
              }

            if ($langs) {
              // leaving <ul> w/o <li> isn't W3C-compliant.
              echo "<ul id=\"languages\">\n";

                foreach ($langs as $code => $path) {
                  if ($code !== $pageLang) {
                    echo "<li> <a href=\"$rootDir../$path\">
                                 <img src=\"$mediaDir/languages/$code.gif\"
                                      alt=\"$code\" title=\"$code\" />
                               </a> </li>\n";
                  }
                }

              echo "</ul>\n";
            }
          ?>

          <div style="background: repeat-y left top url(<?php echo $mediaDir?>/left-rep-y.png);">
          <div style="background: repeat-y right top url(<?php echo $mediaDir?>/right-rep-y.png);">

          <div style="background: repeat-x left top url(<?php echo $mediaDir?>/top-rep-x.png);">
          <div style="background: no-repeat left top url(<?php echo $mediaDir?>/top-left.png)">
          <div style="background: no-repeat right top url(<?php echo $mediaDir?>/top-right.png)">

          <div style="background: repeat-x left bottom url(<?php echo $mediaDir?>/bottom-rep-x.png)">
          <div style="background: no-repeat left bottom url(<?php echo $mediaDir?>/bottom-left.png)">
          <div style="background: no-repeat right bottom url(<?php echo $mediaDir?>/bottom-right.png)">

            <div class="contents-wrapper" id="contentWrapper">
              <div class="contents">
                <div id="rightBorder"></div>

                <div class="header">
                  <??php
                    if (!empty( $_REQUEST['clean-crumbs'] )) {
                      $pages = array();
                    } else {
                      $pages = &$_COOKIE['starry']['breadcrumbs'];
                      $pages and $pages = unserialize($pages);
                      is_array($pages) or $pages = array();
                    }

                      if ($pages) {
                        $html = '';
                        foreach ($pages as $page) {
                          if ($page['destBaseName'] !== $destBaseName or
                              $page['language'] !== $pageLang) {
                            $lang = $page['language'] ? "../$page[language]/" : '';
                            $html .= "<li><a href=\"$rootDir$lang$page[destBaseName]\">$page[title]</a></li>\n";
                          }
                        }

                        if ($html) { ?>
                          <a class="clean-crumbs" href="?clean-crumbs=1">
                            <img src="<?php echo $mediaDir?>/clean-crumbs.png" alt="Clean breadcrumbs" />
                          </a>

                          <ul class="breadcrumbs"><??php echo $html?></ul>
                      <??php
                        }
                      }

                    $pages = array_slice($pages, 0, 5);
                    $pages[$title] = array('title' => $title, 'date' => time(),
                                           'destBaseName' => $destBaseName,
                                           'language' => $pageLang);
                    uasort($pages, create_function('$a, $b',
                      'return $a["date"] > $b["date"] ? 1 : -1;'
                    ));

                    setcookie('starry[breadcrumbs]', serialize($pages),
                              time() + 3600 * 24 * 3, '/');
                  ?>

                  <?php
                    if ($pagePath) {
                      echo '<ul class="path">';

                      foreach ($pagePath as $i => $component) {
                        $url = $rootDir.substr($component['url'], 1);

                        // trailing period makes "/index" page refer to root.
                        echo "<li><a href=\"$url.\">",
                             $i === 0 ? '<img src="'.$mediaDir.'/path-home.png" alt="Home" />' : '',
                             $component['titleHTML']."</a></li>\n";
                      }

                      echo '</ul>';
                    }
                  ?>
                </div>

                <div class="menu">
                  <div id="viewSource">
                    <?php if ($sourceURL !== null) { ?>
                      <a href="<?php echo $sourceURL?>" target="_blank">
                        <img src="<?php echo $mediaDir?>/menu-source.png" alt="Source" />
                      </a>
                    <?php } ?>
                  </div>
                  <div id="history">
                    <?php if ($historyURL !== null) { ?>
                      <a href="<?php echo $historyURL?>" target="_blank">
                        <img src="<?php echo $mediaDir?>/menu-history.png" alt="History" />
                      </a>
                    <?php } ?>
                  </div>

                  <div id="fullWidth" class="js-block"><img src="<?php echo $mediaDir?>/menu-wide.png" alt="Wide/narrow" /></div>

                  <div id="fontInc" class="js-block"><img src="<?php echo $mediaDir?>/menu-font-inc.png" alt="Font+" /></div>
                  <div id="fontDec" class="js-block"><img src="<?php echo $mediaDir?>/menu-font-dec.png" alt="Font-" /></div>
                  <div id="resetSettings" style="display: none"><img src="<?php echo $mediaDir?>/menu-reset.png" alt="Reset" /></div>

                  <div id="toTop">
                    <a href="#top"><img src="<?php echo $mediaDir?>/menu-to-top.png" alt="Top" /></a>
                  </div>
                  <div id="toBottom">
                    <a href="#bottom"><img src="<?php echo $mediaDir?>/menu-to-bottom.png" alt="Bottom" /></a>
                  </div>


                  <div class="js-block" id="favs">
                    <img class="button" src="<?php echo $mediaDir?>/favs.png" alt="Favs" />

                    <div class="list">
                      <div class="buttons">
                        <img src="<?php echo $mediaDir?>/fav-add.png" alt="Add to favs" onclick="AddFav();" />
                        <img src="<?php echo $mediaDir?>/fav-clean.png" alt="Clear" onclick="ClearFavs();" />
                      </div>

                      <ul id="favList">
                      </ul>
                    </div>
                  </div>
                </div>

                <script type="text/javascript">
                  <?php
                    $str = 'window.Strings = {';

                      $strings = array('fav empty' => 'Your favourite pages list is empty.');
                      foreach ($strings as $name => $default) {
                        $string = &$strings['starry evening: '.$name];
                        IsEmptyStr($string) and $string = $default;

                        $string = addcslashes($string, "\00..\31");
                        $str.= "\"$name\": \"$string\"";
                      }

                    echo $str,'};';
                  ?>

                  document.body.className += ' js-enabled';
                  SetupMenu();
                  UpdateFavList();
                </script>

                <script type="text/javascript">SetupMenu();</script>

                <div class="body">
                  <h1><?php echo $titleHTML?></h1>

                  <div id="docTree">
                    <?php
                      $options = array('rootIcon' => $favicon, 'imageURL' => "$mediaDir/tree");
                      echo $task->MakeHtmlTree($baseName, $doc->settings->pager, $options);
                    ?>
                  </div>

                  <?php echo $page?>
                </div>

                <a name="bottom"></a>
              </div>
            </div>

          </div>
          </div>
          </div>

          </div>
          </div>
          </div>

          </div>
          </div>
        </div>
      </div>
      </div>
      </div>
    </div>
    <!-- UTF-8 check: привет! -->
  </body>
</html>
